#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N;
    cin >> N;
    
    vector<int> A(N), B(N);
    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }
    for (int i = 0; i < N; i++) {
        cin >> B[i];
    }
    
    // Prefix arrays for XOR and AND
    vector<int> prefixXor(N + 1, 0); // prefixXor[i] = A[0] ^ A[1] ^ ... ^ A[i-1]
    vector<int> prefixAnd(N + 1, -1); // prefixAnd[i] = B[0] & B[1] & ... & B[i-1]

    // Compute prefix XOR and AND
    for (int i = 1; i <= N; i++) {
        prefixXor[i] = prefixXor[i - 1] ^ A[i - 1];
        prefixAnd[i] = prefixAnd[i - 1] & B[i - 1];
    }
    
    int maxValue = 0;
    
    // Now calculate the result using the prefix arrays
    for (int L = 0; L < N; L++) {
        for (int R = L; R < N; R++) {
            int xorValue = prefixXor[R + 1] ^ prefixXor[L];
            int andValue = prefixAnd[R + 1] & prefixAnd[L];
            maxValue = max(maxValue, xorValue * andValue);
        }       
    }

    cout << maxValue << endl;
    return 0;
}